<?php
/* --------------------------------------------------------------
  ReaderDatabase.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitEan\Repository\Reader;

use Doctrine\DBAL\Connection;

/**
 * Class ReaderDatabase
 * @package Gambio\Shop\Properties\SellingUnitEan\Repository\Reader
 */
class ReaderDatabase implements ReaderInterface
{
    protected const PRODUCTS_PROPERTIES_COMBIS_TABLE_NAME              = "products_properties_combis";
    protected const PRODUCTS_PROPERTIES_COMBIS_TABLE_COLUMN_IDENTIFIER = "products_properties_combis_id";
    protected const PRODUCTS_PROPERTIES_COMBIS_TABLE_COLUMN_VALUE      = "combi_ean";
    
    
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * ReaderDatabase constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getEanValueByCombiId(int $combiId) : string
    {
        $data = $this->connection->createQueryBuilder()->select(
            self::PRODUCTS_PROPERTIES_COMBIS_TABLE_COLUMN_VALUE
        )->from(
            self::PRODUCTS_PROPERTIES_COMBIS_TABLE_NAME
        )->where(self::PRODUCTS_PROPERTIES_COMBIS_TABLE_COLUMN_IDENTIFIER . ' = :combination_id')->setParameter(
            'combination_id',
            $combiId
        )->execute();
        if ($data->rowCount() === 0) {
            return '';
        }
        
        return $data->fetch(0)[self::PRODUCTS_PROPERTIES_COMBIS_TABLE_COLUMN_VALUE];
    }
}